<?php  
session_start();
include('connection.php');
if(!isset($_SESSION['admin_login']) ){
    ?>
<script>
window.location="login.php";
</script>
<?php
}
 $admin_username = $_SESSION['admin_login'];
 $stmt = $con->prepare("SELECT * FROM admin WHERE admin_username = ?");
$stmt->bind_param('s', $admin_username);
$stmt->execute();
$result = $stmt->get_result();

    $admin = $result->fetch_assoc();
   
$stmt->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            display: flex;
            height: 100vh;
            overflow: hidden;
            flex-direction: column;
        }

        /* Sidebar */
        .sidebar {
            width: 250px;
            background-color: #343a40;
            color: white;
            padding-top: 20px;
            position: fixed;
            height: 100%;
        }
        .sidebar a {
            color: white;
            padding: 15px;
            text-decoration: none;
            display: block;
        }
        .sidebar a:hover {
            background-color: #495057;
        }
        .submenu {
            display: none;
            margin-left: 20px;
        }
        .submenu a {
            font-size: 14px;
        }

        /* Main Content */
        .main-content {
            margin-left: 250px;
            padding: 20px;
            overflow-y: auto;
        }

        .card {
            border: none;
            color: white;
        }
        .card i {
            font-size: 48px;
            margin-bottom: 10px;
        }
        .card-title {
            font-size: 18px;
        }
        .card-body {
            text-align: center;
        }

        /* Header */
        .navbar {
            background-color: #007bff;
        }

        .navbar-brand {
            color: white;
        }

        .logout {
            margin-left: 20px;
        }

        /* Footer */
        .footer {
            background-color: #343a40;
            color: white;
            text-align: center;
            padding: 10px 0;
            position: fixed;
            bottom: 0;
            width: 100%;
        }

        .submenu {
            background: #3498DB;
        }
    </style>
</head>
<body>

    <!-- Sidebar -->
    <div class="sidebar">
        <h2 class="text-center text-white">ADMIN PAGE</h2>
        <a href="#" onclick="toggleSubmenu('dashboardSubmenu')">Dashboard</a>
        <div id="dashboardSubmenu" class="submenu">
         <a href="admin_attendancesection.php">Attendance Dashboard</a>
         <a href="admin_classteachersection.php">Class Teacher Dashboard</a>
         <a href="admin_studentsection.php">Student Dashboard</a>
         <a href="admin_teachersection.php">Teachers Dashboard</a>
         <a href="admin_fieldapplication.php">Field Application Dashboard</a>
         <a href="admin_leaveapplication.php">Leave Application Dashboard</a>
         <a href="admin_pastpapersection.php">Past papers Dashboard</a>
         <a href="admin_schoolresults_section.php">School Results Dashboard</a>
        </div>

        <a href="#" onclick="toggleSubmenu('studentsSubmenu')">Students</a>
        <div id="studentsSubmenu" class="submenu">
            <a href="#">Add Student</a>
            <a href="#">See Students</a>
            <a href="#">Delete Student</a>
        </div>

        <a href="#" onclick="toggleSubmenu('feesSubmenu')">Fees Collection</a>
        <div id="feesSubmenu" class="submenu">
            <a href="#">Add Fees</a>
            <a href="#">View Fees</a>
        </div>

        <a href="#" onclick="toggleSubmenu('subjectsSubmenu')">Subjects</a>
        <div id="subjectsSubmenu" class="submenu">
            <a href="#">Add Subject</a>
            <a href="#">See Subjects</a>
            <a href="#">Delete Subject</a>
        </div>

        <a href="#" onclick="toggleSubmenu('teachersSubmenu')">Class Teachers</a>
        <div id="teachersSubmenu" class="submenu">
            <a href="admin_registerclassteacher.php">Add Class Teacher</a>
            <a href="school_teachersnames.php">See Class Teachers</a>
            <a href="#">Delete Class Teacher</a>
        </div>

        <a href="#" onclick="toggleSubmenu('timetableSubmenu')">Admins</a>
        <div id="timetableSubmenu" class="submenu">
            <a href="admin_registration.php">Add Admin</a>
            <a href="school_viewadmins.php">View Admin</a>
        </div>

        <a href="#" onclick="toggleSubmenu('leaveAppSubmenu')">Leave Applications</a>
        <div id="leaveAppSubmenu" class="submenu">
            <a href="#">Apply Leave</a>
            <a href="#">View Applications</a>
        </div>

        <a href="login_history.php">Login history</a>
    </div>
   
    <!-- Main Content -->
    <div class="main-content">
        <!-- Navbar with Logout -->
        <nav class="navbar navbar-light justify-content-between">
            <span class="navbar-brand mb-0 h1">Mwalongo Secondary School</span>
            <div class="d-flex">
                <span class="navbar-text"><?php echo $admin ? $admin['admin_role'] : ''; ?></span>
                <a href="school_logout.php" class="btn btn-danger ms-3">Logout</a>
            </div>
        </nav>
  
        <!-- Success Message -->
        <div class="alert alert-success mt-3">Welcome to your Admin Dashboard!!</div>

        <!-- Dashboard Cards -->
        <div class="row g-4">
            <div class="col-md-3">
                <div class="card bg-primary">
                    <div class="card-body">
                        <i class="bi bi-person"></i>
                        <h5> <a class="card-title" href="school_studentsnames.php" style="text-decoration:none;">Students</a>  </h5>
                        <p class="card-text"><?php 
                            $select="SELECT COUNT(*) AS id FROM students ";
                            $sql=mysqli_query($con, $select);
                            $data=mysqli_fetch_assoc($sql);
                        ?> <b><?php echo $data['id']; ?></b></p>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card bg-success">
                    <div class="card-body">
                        <i class="bi bi-cash-stack"></i>
                        <h5 class="card-title">Fees Collection</h5>
                        <p class="card-text">1</p>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card bg-info">
                    <div class="card-body">
                        <i class="bi bi-bank"></i>
                        <h5 class="card-title">Banks</h5>
                        <p class="card-text">2</p>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card bg-danger">
                    <div class="card-body">
                        <i class="bi bi-person-fill"></i>
                         <h5> <a class="card-title" href="school_teachersnames.php" style="text-decoration:none;">Teachers</a>  </h5>
                        <p class="card-text"><?php 
                            $select="SELECT COUNT(*) AS id FROM school_teachers ";
                            $sql=mysqli_query($con, $select);
                            $data=mysqli_fetch_assoc($sql);
                        ?> <b><?php echo $data['id']; ?></b></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- More Cards -->
        <div class="row g-4 mt-3">
            <div class="col-md-3">
                <div class="card bg-warning">
                    <div class="card-body">
                        <i class="bi bi-book"></i>
                        <h5 class="card-title">Subjects</h5>
                        <p class="card-text">5</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-secondary">
                    <div class="card-body">
                        <i class="bi bi-house"></i>
                        <h5 class="card-title">Hostels</h5>
                        <p class="card-text">2</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-dark">
                    <div class="card-body">
                        <i class="bi bi-calendar"></i>
                        <h5 class="card-title">Timetables</h5>
                        <p class="card-text">0</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-primary">
                    <div class="card-body">
                        <i class="bi bi-trophy"></i>
                        <h5 class="card-title">Exam Results</h5>
                        <p class="card-text">0</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p>&copy; 2024 Mwalongo Secondary School. All rights reserved.</p>
    </div>

    <!-- Bootstrap JS and Icons -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.js"></script>

    <!-- JavaScript for toggling submenus -->
    <script>
        function toggleSubmenu(submenuId) {
            var submenu = document.getElementById(submenuId);
            submenu.style.display = submenu.style.display === "block" ? "none" : "block";
        }
    </script>
</body>
</html>
